/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan
/* - Contents: α׷ UnlimScan4     Ѵ.
/*     ,  α׷ COMI_US_FileConvert () Լ  ʰ,
/*     ̳ʸ   о鿩 ؽƮ Ϸ ȯϰ ȴ. 
/*       ǵ COMI_US_FileSaveFirst(), COMI_US_FileSaveNext()
/*      Լ ̿Ͽ  ̳ʸ  ڰ  д 
/*      ̱  ̴.
/*
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define NUM_CH	2	/* Number of channels */
#define S_FREQ	1000	/* Scan freq. -> 1000 Hz */
#define MSB		40960	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */

//*************************************************************************
//* BinToTextFileConversion() : COMI_US_FileSaveFirst()  Լ 
//*     ̳ʸ  о鿩 ؽƮ Ϸ ȯϴ Լ 
//* - szBinFilePath : ̳ʸ  Path
//* - szTextFilePath : ؽƮ  Path
//* - Return : 0 => , 1 => 
//*************************************************************************/

BOOL BinToTextFileConversion(char *szBinFilePath, char *szTextFilePath)
{
	TScanFileHead Header; // Binary file   Header information ü 
	FILE *fpBin, *fpTxt;
	ULONG dwCnvtedCnt = 0;
	short digits[16];
	float volt, fProgress;
	int i;
	
	if((fpBin = fopen(szBinFilePath, "rb")) == NULL)
		return FALSE;
	
	if((fpTxt = fopen(szTextFilePath, "w")) == NULL){
		fclose(fpBin);
		return FALSE;
	}

	fseek(fpBin, 0L, SEEK_SET); // File pointer ó ġŲ.
	
	// Binary file header  ´. TScanFileHead  ü //
	// Comidas.h Ͽ ǵǾִ.                                //
	fread(&Header, sizeof(TScanFileHead), 1, fpBin); 
	
	// Text file ŸƲ ʵ带 ۼѴ. //
	fprintf(fpTxt, "Date : %s,   Time : %s\n", Header.szDate, Header.szTime);
	for(i=0; i<Header.nNumChan; i++)
		fprintf(fpTxt, "   CH%2d ", Header.nChanList[i]);
	fprintf(fpTxt, "\n");
	
	// Binary file 1 scan line о鿩   Text file //
	// ƮѴ. (äμ  1 scan ̷)            //                                                //
	while(fread(digits, sizeof(short), Header.nNumChan, fpBin))
	{
		for(i=0; i<Header.nNumChan; i++){
			if(Header.dmin < 0)
				volt = (float)COMI_Digit16ToVolt(digits[i], Header.vmin[i], Header.vmax[i]);
			else
				volt = (float)COMI_DigitToVolt(digits[i], Header.vmin[i], Header.vmax[i]);
			fprintf(fpTxt, "%7.3f ", volt);
		}
		fprintf(fpTxt, "\n");
		dwCnvtedCnt++;
		if(!(dwCnvtedCnt % 100)){ // 100ȸ scan line Ͱ ɶ  ǥ 
			fProgress = 100.f * (float)dwCnvtedCnt/(float)Header.dwSavedScanCnt;
			// Conversion  ȭ鿡 ش. //
			printf("Conversion progress = %.0f %c\n", fProgress, '%');
		}
	}
	fclose(fpTxt);
	fclose(fpBin);
	return TRUE;
}



void main (void)
{
	HANDLE hDevice;
	int ch_list[2] = {0, 4};  /* Scan channel list : 0  4 ä */
	ULONG dwSavedScanCnt=0;
	BOOL bSuccess;

	/* Load DLL */
	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	// Set A/D range //
	COMI_AD_SetRange(hDevice, 0, -10, 10);
	COMI_AD_SetRange(hDevice, 4, -10, 10);
	
	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	/* start unlimited scan */
	long act_freq = COMI_US_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!");
		printf("%s", COMI_ErrorString (COMI_LastError())); 
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch(); 
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
		exit(0);
	}

	// Start file save //
	dwSavedScanCnt = 0;
	if(COMI_US_FileSaveFirst (hDevice, "c:\\ComiUscan.bin", TRUE)) 
	{
		while(!kbhit())
		{
			Sleep(100);
			dwSavedScanCnt += COMI_US_FileSaveNext(hDevice); // Continue file save
			printf("Total save scan count = %u\n", dwSavedScanCnt);
		}
	}
	COMI_US_FileSaveStop(hDevice); // Stop file save
	COMI_US_Stop (hDevice, TRUE); // Stop unlimited scan

	// Convert binary file to text file //
	bSuccess = BinToTextFileConversion ("c:\\ComiUscan.bin", "c:\\ComiUscan.txt");
	if(!bSuccess)
		printf("File conversion failed !");

	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
